// Autor: Frane Kurtovic

#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

const int MAXN = 101;
char mat[MAXN][MAXN];
int n, k;

int max_cnt(vector <char> &e) {
    sort(e.begin(), e.end());
    int start = 0, mx_cnt = 0;
    for (int i = 0; i < (int)e.size(); i++) {
      if (e[i] != e[start]) {
        mx_cnt = max(mx_cnt, i - start);
        start = i;
      }
    }
    return max(mx_cnt, (int)e.size() - start);
}

int calc(int r, int c) {
  int ret = 0;
  int mid = (k + 1) / 2;
  for (int i = 0; i < mid; i++) {
    int i_end = k - i - 1;
    for (int j = 0; j < mid; j++) {
      vector <char> e;
      int j_end = k - j - 1;
      e.push_back(mat[r + i][c + j]);
      if (i_end != i) e.push_back(mat[r + i_end][c + j]);
      if (j_end != j) e.push_back(mat[r + i][c + j_end]);
      if (j_end != j && i_end != i) e.push_back(mat[r + i_end][c + j_end]);
      ret += e.size() - max_cnt(e);
    }
  }
  return ret;
}

int main() {
  cin >> n >> k;
  for (int i = 0; i < n; i++) {
    cin >> mat[i];
  }
  int ret = n * n, best_r, best_c;
  for (int r = 0; r < n; r++) {
    for (int c = 0; c < n; c++) {
      if (r + k > n || c + k > n) continue;
      int v = calc(r, c);
      if (v < ret) {
        ret = v;
        best_r = r;
        best_c = c;
      }
      ret = min(ret, calc(r, c));
    }
  }
  cout << ret << endl;
  // cout << best_r << " " << best_c << endl;
  return 0;
}
